<?php
header('Content-Type: application/json');

// Google Gemini API Key (apni valid key yahan lagayen)
$api_key = "AIzaSyC90O0wEx7jj77IwHPVZBd9GoZfFtHDSeY";

// Output folder for AI generated images
$outputDir = "outputs/";
if (!file_exists($outputDir)) {
    mkdir($outputDir, 0777, true);
}

// Collect POST inputs (simple text only, no images)
$storyPointsInput = $_POST['story_points'] ?? '';
$visualStyle = $_POST['visual_style'] ?? 'realistic';

// Validation
if (empty($storyPointsInput)) {
    echo json_encode(["status" => "error", "message" => "Please enter story points."]);
    exit;
}

if (empty($visualStyle)) {
    echo json_encode(["status" => "error", "message" => "Please select a visual style."]);
    exit;
}

// Prepare prompt from story points
$storyPoints = is_array($storyPointsInput)
    ? array_map('trim', $storyPointsInput)
    : array_map('trim', explode(',', $storyPointsInput));

$storyText = implode('. ', $storyPoints);

// Gemini 2.5 flash image generation endpoint
$url = "https://generativelanguage.googleapis.com/v1beta/models/gemini-2.5-flash-image:generateContent";

// Prepare the prompt in the payload format Gemini expects
$promptText = "Generate an image in {$visualStyle} style for this story: {$storyText}.";

$payload = [
    "contents" => [
        [
            "parts" => [
                ["text" => $promptText]
            ]
        ]
    ]
];

// Setup cURL
$ch = curl_init($url);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_HTTPHEADER => [
        "Content-Type: application/json",
        "x-goog-api-key: $api_key"
    ],
    CURLOPT_POSTFIELDS => json_encode($payload)
]);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http_code !== 200) {
    echo json_encode([
        "status" => "error",
        "message" => "Failed to generate image.",
        "http_code" => $http_code,
        "response" => $response
    ]);
    exit;
}

// Decode response JSON
$data = json_decode($response, true);

// Extract base64 image data from response
$img_base64 = $data['candidates'][0]['content']['parts'][1]['inline_data']['data'] ?? null;

if (!$img_base64) {
    echo json_encode([
        "status" => "error",
        "message" => "Image data not found in API response.",
        "response_sample" => substr($response, 0, 300)
    ]);
    exit;
}

// Decode and save the image file
$imageData = base64_decode($img_base64);
$outputFile = $outputDir . "gemini_image_" . time() . ".png";

if (file_put_contents($outputFile, $imageData) === false) {
    echo json_encode([
        "status" => "error",
        "message" => "Failed to save generated image."
    ]);
    exit;
}

// Success response
echo json_encode([
    "status" => "success",
    "message" => "Image generated successfully.",
    "image_path" => $outputFile,
    "story_points" => $storyPoints,
    "visual_style" => $visualStyle
]);
?>
